/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketInventoryContainerChange
extends APacketEntity<EntityInventoryContainer> {
    private final int index;
    private final IWrapperItemStack stackToChangeTo;

    public PacketInventoryContainerChange(EntityInventoryContainer inventory, int index, IWrapperItemStack stackToChangeTo) {
        super(inventory);
        this.index = index;
        this.stackToChangeTo = stackToChangeTo;
    }

    public PacketInventoryContainerChange(ByteBuf buf) {
        super(buf);
        this.index = buf.readInt();
        this.stackToChangeTo = PacketInventoryContainerChange.readDataFromBuffer(buf).getStacks(1).get(0);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.index);
        IWrapperNBT stackData = InterfaceManager.coreInterface.getNewNBTWrapper();
        ArrayList<IWrapperItemStack> stackList = new ArrayList<IWrapperItemStack>();
        stackList.add(this.stackToChangeTo);
        stackData.setStacks(stackList);
        PacketInventoryContainerChange.writeDataToBuffer(stackData, buf);
    }

    @Override
    public boolean handle(AWrapperWorld world, EntityInventoryContainer inventory) {
        inventory.setStack(this.stackToChangeTo, this.index);
        return false;
    }
}

